function design = P14base_1d(k, d, P14base)
%MISC_1D Generates a 1D MISC array.
%Syntax:
%   design = MISC_1d(n, wavelength/2, 'MISC Array');
%Inputs:
%   n - sensor amount.
%   d - Inter-element spacing.
%   name - Custom name of the array. Default is 'MISC array (m)'.
%Outputs:
%   design - An array design struct.
if k <= 7
    error('Sensor amount must larger than 7.');
end
% ========= array configuration ============
% ========= decide spacing
n = floor((k-4)/8);
m = k-4*n-4;
%%%%%%%%%%%%%%%
num_array = 7;
mid_count = ceil((1+num_array)/2);
sn_1 = 4;
sn_2 = 1;
sn_3 = sn_1;
n_1 = n;
sn_4 = sn_1*(n_1) + 5;
sn_5 = sn_1;
sn_6 = 2;
sn_7 = sn_1;
%%%%%%%%%%%%%%%%%%%
n_2 = 2;
n_6 = 2;
n_3 = n_1;
n_4 = m;
n_5 = n_1;
n_7 = n_1;
%%%%%%%%%%%%%%%%%%%
interspace_12 = 3;
interspace_23 = 7;
interspace_34 = 4;
interspace_45 = 5;
interspace_56 = 3;
interspace_67 = 6;


% ========= subarray designs ===========
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%  compute initial position   %%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
for initial_count=1:num_array
    if initial_count==1
        eval(['i_',num2str(initial_count),'=0',';'])
    else 
        eval(['i_',num2str(initial_count),'=i_',num2str(initial_count-1),'+(n_',num2str(initial_count-1),'-1)*sn_',num2str(initial_count-1),'+interspace_',num2str(initial_count-1),num2str(initial_count),';'])
    end 
end 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%  compute sub arrays   %%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
for initial_count=1:num_array
    eval(['sub',num2str(initial_count),'=[]',';'])
    eval(['count1=n_',num2str(initial_count),';'])
    for sub_count=1:count1
        eval(['sub',num2str(initial_count),'(sub_count) = (sub_count-1)','*sn_',num2str(initial_count),';'])
    end
    eval(['sub',num2str(initial_count),'=sub',num2str(initial_count),'+i_',num2str(initial_count),';'])
end 

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%% compute array address  %%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
arr_indices = [];
for p = 1:num_array
    eval(['arr_indices = [ arr_indices sub',num2str(p),'];'])
end
%%%%%%%%%%%%%%%%%%%%%%%%%


if d <= 0 || ~isreal(d)
    error('d must be a positive real number.');
end
if nargin <= 2
    name = sprintf('4 base  array solution 1 %d sensors', k);
elseif ~ischar(name)
    error('Name must be a string.');
end
design.element_indices = arr_indices;
%design.element_indices = union(design.element_indices, (n1*n2+n2+n1-2));
design.element_positions = design.element_indices*d;
design.element_spacing = d;
design.element_count = length(design.element_indices);
design.dim = 1;
design.type = '4base P1 Subarray';
design.name = name;
end